//---------------------------------------------------------------------------

#ifndef GLFormH
#define GLFormH
//---------------------------------------------------------------------------

#include <Forms.hpp>
#include <ExtCtrls.hpp>

#include <gl.h>
#include <glu.h>

class TGLForm : public TForm
{
__published:
   __property TColor KolorTla = {read=kolorTla,write=UstawKolorTla};
private:	//prywatne pola i metody zwiazane z OpenGL
   HDC uchwytDC; //uchwyt do "display device context (DC)"
   HGLRC uchwytRC; //uchwyt do "OpenGL rendering context"
   bool GL_UstalFormatPikseli(HDC uchwytDC);
   void GL_UstawienieSceny();
   TColor kolorTla;
   void __fastcall UstawKolorTla(TColor kolorTla);
   void __fastcall WndProc(TMessage& Message);
   //kamera
   int X0,Y0;
   float KameraPhi, KameraTheta, KameraR;
   float tmpKameraPhi, tmpKameraTheta;
   float KameraX, KameraY;
   float tmpKameraX, tmpKameraY;
   void __fastcall DebugInfo();
   //swobodne obroty kamery
   int SzybkoscX0,SzybkoscY0;
   float SzybkoscPhi, SzybkoscTheta;
   bool SzybkoscWlaczone;
   TTimer* SzybkoscTimer;
   void __fastcall SzybkoscTimerTimer(TObject* Sender);
   float SzybkoscWygaszania;
protected:
   bool debug_mode;
   void __fastcall GL_RysujScene();
   virtual void __fastcall RysujScene() = 0; //abstrakcyjna, musi byc zdefiniowana w klasie potomnej
   virtual void __fastcall Pomoc(); //mozna zastapic te metoda inna
   void __fastcall Obracaj(float SzybkoscPhi,float SzybkoscTheta,float SzybkoscWygaszania);
   void __fastcall RysujOsie(float rozmiar);
public:
   __fastcall TGLForm(TComponent* Owner);
   __fastcall ~TGLForm();
};

#endif

